let searchField = document.querySelector('#query');
let button = document.querySelector('.search-button');
let playerName = document.querySelector('.playerName');
let playerImg = document.querySelector('.avatar');
let clubsDiv = document.querySelector('.clubs');
let clubsList = document.querySelector('.clubslist');
let playerFollowers = document.querySelector('.followers');
let playerCountry = document.querySelector('.country');
let playerTitle = document.querySelector('.title');
let playerStatus = document.querySelector('.onlinestatus');
let playerTactics = document.querySelector('.playertactics');
let lastTournament = document.querySelector('.tournament');

let playerBlitz = document.querySelector('.playerblitz');
let playerBullet = document.querySelector('.playerbullet');
let playerRapid = document.querySelector('.playerrapid');

let playerNumber = document.querySelector('.worldnumber')


async function getChess(player) {
    let response = await fetch('https://api.chess.com/pub/player/' + player);
    let data = await response.json();
    console.log(data);
    playerName.innerText = data.name;
    playerImg.src = data.avatar;
    playerFollowers.innerText = "Followers: " + data.followers;
    playerTitle.innerText = data.title;
    
    
}

async function getNumber(player) {
    let response = await fetch('https://api.chess.com/pub/leaderboards' + player);
    let data = await response.json();
    console.log(data);
    playerNumber = data.live_rapid;
    
    
}


async function getCountry(player) {
    let response = await fetch('https://api.chess.com/pub/player/' + player);
    let data = await response.json();
    console.log(data);
    let countryResponse = await fetch(data.country);
    let countryData = await countryResponse.json();
    playerCountry.innerText = countryData.name;

    
}




async function getStatus(player) {
    let response = await fetch('https://api.chess.com/pub/player/' + player + '/is-online');
    let data = await response.json();
    console.log(data);
    playerStatus.innerText = data.online;
    
}



async function getTactics(player){
    let response = await fetch('https://api.chess.com/pub/player/' + player + '/stats');
    let data = await response.json();
    console.log(data);
    playerTactics.innerText = "Highest Puzzle Rating: " + data.tactics.highest.rating;

}

async function getBlitz(player){
    let response = await fetch('https://api.chess.com/pub/player/' + player + '/stats');
    let data = await response.json();
    console.log(data);
    playerBlitz.innerText = "Highest Blitz Rating: " + data.chess_blitz.last.rating;

}

async function getBullet(player){
    let response = await fetch('https://api.chess.com/pub/player/' + player + '/stats');
    let data = await response.json();
    console.log(data);
    playerBullet.innerText = "Highest Bullet Rating: " + data.chess_bullet.last.rating;
}

async function getRapid(player){
    let response = await fetch('https://api.chess.com/pub/player/' + player + '/stats');
    let data = await response.json();
    console.log(data);
    playerRapid.innerText = "Highest Rapid Rating: " + data.chess_rapid.last.rating;
}




async function getTournament(player){
    let response = await fetch('https://api.chess.com/pub/tournament/' + player);
    let data = await response.json();
    console.log(data);
    lastTournament.innerText = "Last Tournament: " + data.name;
    
}





async function getClubs(player) {
    let response = await fetch('https://api.chess.com/pub/player/' + player + '/clubs');
    let data = await response.json();
    console.log(data);
    clubsDiv.insertAdjacentHTML('afterbegin', `<h2>Clubs</h2>`);
    data.clubs.forEach(club => {
        clubsList.insertAdjacentHTML('beforeend', `
            <li>${club.name}</li>
        `)
    })

}





button.addEventListener('click', () => {
    let playerValue = searchField.value;
    getChess(playerValue);
    getClubs(playerValue);
    getTactics(playerValue);
    getTournament(playerValue);
    getBlitz(playerValue);
    getBullet(playerValue);
    getRapid(playerValue);
    getStatus(playerValue);
    getCountry(playerValue);
    getNumber(playerValue);
})